.386P
.MODEL FLAT,C

_TEXT SEGMENT DWORD PUBLIC 'CODE'
        ASSUME CS:_TEXT,DS:_DATA

; - interface ---------------------------------------------------------------
public  FadeOutTextScreen_ASM

public  GetVESAInfo_ASM

public  Detect320x200Mode_ASM

public  InterpolateFrameBuffer_ASM
public  InterpolateFrameBuffer2_ASM
; - implementacio -----------------------------------------------------------
modenr dd 0
bitsperpixelwanted db 0

; - 16 szin kifader ---------------------------------------------------------
FadeOutTextScreen_ASM          PROC NEAR

                mov bl,32 ; arnyalatok (32 -> 0)
fNxtShade:      mov cx,16 ; szinek
fNxtColor:      mov dx,3DAh  ; vertical retrace-hez idozites
fWait2:         in al,dx
                test al,8h
                jz fWait2

                mov dx,03C8h ; szin indexe a 0x03C8-as portra
                mov al,cl
                out dx,al
                inc dx ; RGB komponensek a 0x03C9-es portra
                mov al,bl
                out dx,al
                out dx,al
                out dx,al
                dec cx
                jnz fNxtColor

                dec bl
                jnz fNxtShade

                ret

FadeOutTextScreen_ASM          ENDP

; - kepernyo interpolator (4-4 pixel vizszintesen es fuggolegesen) mag ------
InterpolateFrameBuffer_ASM     PROC NEAR
                ; parameter: EDI -> framebuffer

                push ebp

                ; vizszintes interpolacio
                push edi
                mov ebp,46 ; sorok
NxtLine:        mov esi,80 ; interpolalando pixelek
NxtTriplet:     xor eax,eax ; pixeltarolok es deltak uritese
                xor ebx,ebx
                xor ecx,ecx
                xor edx,edx

                mov ah,byte ptr [edi] ; B1 be
                mov ch,byte ptr [edi + 1] ; G1 be
                mov bh,byte ptr [edi + 4*4] ; B2 be
                mov dh,byte ptr [edi + 4*4 + 1] ; G2 be

                sub ebx,eax ; B2 - B1
                sub edx,ecx ; G2 - G1
                sar ebx,2 ; BX:= ((B2 - B1)<<8)/4
                sar edx,2 ; DX:= ((G2 - G1)<<8)/4

                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 4],ah
                mov byte ptr [edi + 4 + 1],ch
                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 2*4],ah
                mov byte ptr [edi + 2*4 + 1],ch
                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 3*4],ah
                mov byte ptr [edi + 3*4 + 1],ch

                xor eax,eax
                xor ebx,ebx
                mov ah,byte ptr [edi + 2] ; R1 be
                mov bh,byte ptr [edi + 4*4 + 2] ; R2 be
                sub ebx,eax ; R2 - R1
                sar ebx,2 ; BX:= ((R2 - R1)<<8)/4

                add eax,ebx
                mov byte ptr [edi + 4 + 2],ah
                add eax,ebx
                mov byte ptr [edi + 2*4 + 2],ah
                add eax,ebx
                mov byte ptr [edi + 3*4 + 2],ah

                add edi,4*4 ; kovetkezo pixel 4-gyel jobbra
                dec esi
                jnz NxtTriplet
                add edi,3*4*320 ; kovetkezo sor 4-gyel lejjebb
                dec ebp
                jnz NxtLine

                ; fuggoleges interpolacio
                pop edi
                mov ebp,45
NxtHLine:       mov esi,320 ; interpolalando pixelek
NxtHTriplet:    xor eax,eax ; pixeltarolok es deltak uritese
                xor ebx,ebx
                xor ecx,ecx
                xor edx,edx

                mov ah,byte ptr [edi] ; B1 be
                mov ch,byte ptr [edi + 1] ; G1 be
                mov bh,byte ptr [edi + 4*4*320] ; B2 be
                mov dh,byte ptr [edi + 4*4*320 + 1] ; G2 be

                sub ebx,eax ; B2 - B1
                sub edx,ecx ; G2 - G1
                sar ebx,2 ; BX:= ((B2 - B1)<<8)/4
                sar edx,2 ; DX:= ((G2 - G1)<<8)/4

                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 4*320],ah
                mov byte ptr [edi + 4*320 + 1],ch
                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 2*4*320],ah
                mov byte ptr [edi + 2*4*320 + 1],ch
                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 3*4*320],ah
                mov byte ptr [edi + 3*4*320 + 1],ch

                xor eax,eax
                xor ebx,ebx
                mov ah,byte ptr [edi + 2] ; R1 be
                mov bh,byte ptr [edi + 4*4*320 + 2] ; R2 be
                sub ebx,eax ; R2 - R1
                sar ebx,2 ; BX:= ((R2 - R1)<<8)/4

                add eax,ebx
                mov byte ptr [edi + 4*320 + 2],ah
                add eax,ebx
                mov byte ptr [edi + 2*4*320 + 2],ah
                add eax,ebx
                mov byte ptr [edi + 3*4*320 + 2],ah

                add edi,4 ; kovetkezo pixel 1-el jobbra
                dec esi
                jnz NxtHTriplet
                add edi,3*4*320 ; kovetkezo sor 4-gyel lejjebb
                dec ebp
                jnz NxtHLine

                pop ebp
                ret

InterpolateFrameBuffer_ASM     ENDP

InterpolateFrameBuffer2_ASM    PROC NEAR
                ; parameter: EDI -> framebuffer

                push ebp

                ; vizszintes interpolacio
                push edi
                mov ebp,91 ; sorok
NxtLine2:       mov esi,160 ; interpolalando pixelek
NxtTriplet2:    xor eax,eax ; pixeltarolok es deltak uritese
                xor ebx,ebx
                xor ecx,ecx
                xor edx,edx

                mov ah,byte ptr [edi] ; B1 be
                mov ch,byte ptr [edi + 1] ; G1 be
                mov bh,byte ptr [edi + 2*4] ; B2 be
                mov dh,byte ptr [edi + 2*4 + 1] ; G2 be

                sub ebx,eax ; B2 - B1
                sub edx,ecx ; G2 - G1
                sar ebx,1 ; BX:= ((B2 - B1)<<8)/2
                sar edx,1 ; DX:= ((G2 - G1)<<8)/2

                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 4],ah
                mov byte ptr [edi + 4 + 1],ch

                xor eax,eax
                xor ebx,ebx
                mov ah,byte ptr [edi + 2] ; R1 be
                mov bh,byte ptr [edi + 2*4 + 2] ; R2 be
                sub ebx,eax ; R2 - R1
                sar ebx,1 ; BX:= ((R2 - R1)<<8)/4
                add eax,ebx
                mov byte ptr [edi + 4 + 2],ah

                add edi,2*4 ; kovetkezo pixel 2-vel jobbra
                dec esi
                jnz NxtTriplet2
                add edi,4*320 ; kovetkezo sor 2-vel lejjebb
                dec ebp
                jnz NxtLine2

                ; fuggoleges interpolacio
                pop edi
                mov ebp,90
NxtHLine2:      mov esi,320 ; interpolalando pixelek
NxtHTriplet2:   xor eax,eax ; pixeltarolok es deltak uritese
                xor ebx,ebx
                xor ecx,ecx
                xor edx,edx

                mov ah,byte ptr [edi] ; B1 be
                mov ch,byte ptr [edi + 1] ; G1 be
                mov bh,byte ptr [edi + 2*4*320] ; B2 be
                mov dh,byte ptr [edi + 2*4*320 + 1] ; G2 be

                sub ebx,eax ; B2 - B1
                sub edx,ecx ; G2 - G1
                sar ebx,1 ; BX:= ((B2 - B1)<<8)/2
                sar edx,1 ; DX:= ((G2 - G1)<<8)/2

                add eax,ebx
                add ecx,edx
                mov byte ptr [edi + 4*320],ah
                mov byte ptr [edi + 4*320 + 1],ch

                xor eax,eax
                xor ebx,ebx
                mov ah,byte ptr [edi + 2] ; R1 be
                mov bh,byte ptr [edi + 2*4*320 + 2] ; R2 be
                sub ebx,eax ; R2 - R1
                sar ebx,1 ; BX:= ((R2 - R1)<<8)/2

                add eax,ebx
                mov byte ptr [edi + 4*320 + 2],ah

                add edi,4 ; kovetkezo pixel 1-el jobbra
                dec esi
                jnz NxtHTriplet2
                add edi,4*320 ; kovetkezo sor 2-vel lejjebb
                dec ebp
                jnz NxtHLine2

                pop ebp
                ret

InterpolateFrameBuffer2_ASM    ENDP

; - VESA informaciot lekero mag ---------------------------------------------
GetVesaInfo_ASM PROC NEAR

                ; real mode memoriafoglalas a VESAInfoBlock-nak:
                mov ax,0100h
                mov bx,512/16               ; blokk merete paragraph-ban
                int 31h
                mov ecx,eax                 ; blockpointer elmentese
                and ecx,0FFFFh
                shl ecx,4
                mov [dosmem_address],ecx
                mov [dosmem_segment],ax
                mov [dosmem_selector],dx

                ; GetVesaInfo VBE hivas:
                mov edi,offset RMREGS
                mov [rm_eax],4F00h
                mov [rm_es],ax
                mov [rm_edi],0
                mov eax,0300h               ; DPMI realmode interrupt hivas
                mov bx,010h
                mov cx,0
                int 031h

                mov ecx,[dosmem_address]    ; visszateresi ertek: VBE verzio
                movzx eax,[ecx.VBEINFOBLOCK.VbeVersion]

                ret

GetVesaInfo_ASM ENDP

Detect320x200Mode_ASM     PROC NEAR
                ; parameter: EBX:= kivant bpp, ESI:= LFB tarolo cime

                push esi
                mov [bitsperpixelwanted],bl
                mov [modenr],04100h

                ; GetVesaModeInfo VBE hivas:
TestNxtMode:    mov edi,offset RMREGS
                mov [rm_eax],04F01h
                mov eax,[modenr]
                mov [rm_ecx],eax            ; videomod kodja
                mov ax,[dosmem_segment]
                mov [rm_es],ax
                mov [rm_edi],0
                mov eax,0300h               ; DPMI realmode interrupt hivas
                mov ebx,010h
                mov cx,0
                int 31h

                mov ecx,[dosmem_address]    ; a videomod 320x200xbpp_wanted?
                cmp [ecx.VBEINFOBLOCK.XResolution],320
                jne NxtVidMode
                cmp [ecx.VBEINFOBLOCK.YResolution],200
                jne NxtVidMode
                mov al,[bitsperpixelwanted]
                cmp [ecx.VBEINFOBLOCK.BitsPerPixel],al
                jne NxtVidMode

                mov ebx,[modenr]            ; visszateresi ertek: detektalt videomod
                pop esi
                mov eax,[ecx.VBEINFOBLOCK.PhysBasePtr]
                mov dword ptr [esi],eax     ; LFB cimenek bemasolasa
                jmp FreeBuffer

NxtVidMode:     inc [modenr]                ; kovetkezo videomod
                cmp [modenr],04100h + 256   ; 256-ot probalunk vegig
                jb TestNxtMode

                xor ebx,ebx                 ; visszateresi ertek: 0
                pop esi
                mov dword ptr [esi],0       ; LFB cime is 0
FreeBuffer:     mov ax,0101h                ; DOS buffer felszabaditasa
                mov dx,[dosmem_selector]
                int 031h

                ret

Detect320x200Mode_ASM     ENDP

_TEXT ENDS

_DATA   SEGMENT use32 DWORD PUBLIC 'DATA'
          ASSUME DS:_DATA

; - realmode regiszterek kepe a 300h-s DPMI hivashoz ------------------------
RMREGS    label   dword
          rm_edi            dd      0
          rm_esi            dd      0
          rm_ebp            dd      0
          rm_esp            dd      0
          rm_ebx            dd      0
          rm_edx            dd      0
          rm_ecx            dd      0
          rm_eax            dd      0
          rm_flags          dw      0
          rm_es             dw      0
          rm_ds             dw      0
          rm_fs             dw      0
          rm_gs             dw      0
          rm_ip             dw      0
          rm_cs             dw      0
          rm_sp             dw      0
          rm_ss             dw      0
          rm_sparedata      dd      20 dup (0)

; - VBEInfoBlock struktura --------------------------------------------------
VBEINFOBLOCK    STRUC

VbeSignature        db 'VESA'        ; VBE Signature
VbeVersion          dw 0200h         ; VBE Version
OemStringPtr        dd ?             ; Pointer to OEM String
Capabilities        db 4 dup (?)     ; Capabilities of graphics cont.
VideoModePtr        dd ?             ; Pointer to Video Mode List
TotalMemory         dw ?             ; Number of 64kb memory blocks

OemSoftwareRev      dw ?             ; VBE implementation Software revision
OemVendorNamePtr    dd ?             ; Pointer to Vendor Name String
OemProductNamePtr   dd ?             ; Pointer to Product Name String
OemProductRevPtr    dd ?             ; Pointer to Product Revision String
_Reserved_          db 222 dup (?)   ; Reserved for VBE implementation

OemData             db   256 dup (?) ; Data Area for OEM Strings

VBEINFOBLOCK    ENDS

; - VBEModeInfoBlock struktura ----------------------------------------------
MODEINFOBLOCK   STRUC

ModeAttributes      dw ?        ; mode attributes
WinAAttributes      db ?        ; window A attributes
WinBAttributes      db ?        ; window B attributes
WinGranularity      dw ?        ; window granularity
WinSize             dw ?        ; window size
WinASegment         dw ?        ; window A start segment
WinBSegment         dw ?        ; window B start segment
WinFuncPtr          dd ?        ; pointer to window function
BytesPerScanLine    dw ?        ; bytes per scan line

XResolution         dw ?        ; horizontal resolution in pixels or chars
YResolution         dw ?        ; vertical resolution in pixels or chars
XCharSize           db ?        ; character cell width in pixels
YCharSize           db ?        ; character cell height in pixels
NumberOfPlanes      db ?        ; number of memory planes
BitsPerPixel        db ?        ; bits per pixel
NumberOfBanks       db ?        ; number of banks
MemoryModel         db ?        ; memory model type
BankSize            db ?        ; bank size in KB
NumberOfImagePages  db ?        ; number of images
_Reserved           db ?        ; reserved for page function

RedMaskSize         db ?        ; size of direct color red mask in bits
RedFieldPosition    db ?        ; bit position of lsb of red mask
GreenMaskSize       db ?        ; size of direct color green mask in bits
GreenFieldPosition  db ?        ; bit position of lsb of green mask
BlueMaskSize        db ?        ; size of direct color blue mask in bits
BlueFieldPosition   db ?        ; bit position of lsb of blue mask
RsvdMaskSize        db ?        ; size of direct color reserved mask in bits
RsvdFieldPosition   db ?        ; bit position of lsb of reserved mask
DirectColorModeInfo db ?        ; direct color mode attributes

        ; Mandatory information for VBE 2.0 and above:

PhysBasePtr         dd ?        ; physical address for flat frame buffer
OffScreenMemOffset  dd ?        ; pointer to start of off screen memory
OffScreenMemSize    dw ?        ; amount of off screen memory in 1k units
__Reserved          db 206 dup (?)

MODEINFOBLOCK   ENDS

; - ideiglenes tarolok a DPMI-vel foglalt memoriahoz ------------------------
dosmem_address      dd 0
dosmem_segment      dw 0
dosmem_selector     dw 0

_DATA ENDS

END